[This work is licensed under a Creative Commons Attribution 3.0 United States License.]

"Winter" by "chrisamaphone"

Use full-length room descriptions.

When play begins:
	change the right hand status line to
		"Score: [score] / Turns: [turn count]".
Every turn:
	if the score is greater than 1:
		say "Having recapitated a snowman and skated on a frozen pond, you have defeated the perilous cold and had good fun.";
		end the game in victory.
test me with "get snow / n / put snowball on snowman / sit on bench / doff boots / wear skates / skate".

The description of the player is "You're bundled up in a stylish winter parka."

The player is wearing a parka.
The description of the parka is "It's warm, soft and stylish to boot."
Instead of taking off the parka, say "It's much too cold for exhibitionism.".

The player is wearing a pair of boots.
The description of the boots is "Tall boots with woolen lining."
Understand "shoes" as the boots.

The player is carrying a pair of ice skates. The ice skates are wearable.
The description of the ice skates is "You bought the skates yesterday and can't wait to try them out."
Understand "skates" as the ice skates.

Instead of wearing the skates when the player wears the boots:
	say "You'll have to take off the boots first.".
	
Instead of wearing the boots when the player wears the skates:
	say "You'll have to take off the skates first."

Chapter 1 - A Snowy Expanse

A Snowy Expanse is a room. "The sky is achingly bright; snow stretches around you. You see a glint of ice to the north.

It is very bright here. You are likely to be peacefully observed by a co-grue."
A Snowy Expanse is south of An Icy Expanse.

The pond is a backdrop. The pond is in A Snowy Expanse and An Icy Expanse.
Understand "ice" as the pond. [XXX this doesn't work]

Instead of examining the pond:
	if the player is in A Snowy Expanse
	begin;
		say "The ice in the distance reflects bright light into your eyes.";
	otherwise;
		say "The ice gleams in the sunlight. You think it is solid enough to hold your weight -- it hasn't been above freezing in a few days.";
	end if.

[[ snowball dispenser! ]]
snow is scenery in A Snowy Expanse. "The snow glitters in the sunlight."

There is a snowball. The description is "A fat, fluffy snowball."

Instead of taking the snow:
	if the snowball is off-stage:
		move the snowball to the player;
		say "You scoop up some snow and pack it into a neat ball.";
	otherwise:
		say "You feel satisfied with one snowball."

Report dropping the snowball:
	say "The snowball lands on a soft mound of snow and remains in tact."; stop the action.
	
Understand the command "throw" as something new.
Throwing is an action applying to one thing.
Understand "throw [something]" as throwing.
Instead of throwing the snowball:
	if the player carries the snowball
	begin;
		say "You hurl the snowball into the distance! It crumbles into the expanse whence it came.";
		remove the snowball from play;
	otherwise;
		say "You're not holding that.";
	end if.
Instead of eating the snowball:
	if the player carries the snowball
	begin;
		say "You eat the snowball. Om nom nbrrr...";
		remove the snowball from play;
	otherwise;
		say "You're not holding that.";
	end if.

Understand "snow" as the snowball when the snowball is visible.

[Instead of dropping the snow, try dropping the snowball.
Instead of throwing the snow, try throwing the snowball.]
[XXX FIX EATING SNOW]
[Instead of eating the snow:
	if the player carries the snowball
	begin;
		try eating the snowball;
	otherwise;
		say "You plant your face into a mound of snow and eat it. Om nom brrrrr.";
	end if.]

Chapter 2 - An Icy Expanse

An Icy Expanse is north of A Snowy Expanse. "The pond here is frozen solid."

Understand "rink" as the pond.
Understand "frozen" as the pond.

[[[[[[[ Skating puzzle ]]]]]]]
The bench is an enterable supporter in An Icy Expanse. 
It is fixed in place.
The description of the bench is "A little wooden park bench with iron armrests.".

Before going somewhere when the player is on a supporter (called the chaise):
    say "(first getting off [the chaise])[command clarification break]";
    silently try exiting. 

[Understand the command "sit" as something new.
Sitting is an action applying to nothing.
Understand "sit" as sitting.
Instead of sitting:
	if the player is in An Icy Expanse begin;
		try entering the bench;
	otherwise;
		try entering;
	end if.]

Instead of entering the bench:
	say "You sit on the creaky wooden bench.";
	now the player is on the bench.
Instead of getting off the bench:
	if the player is not wearing the boots and the player is not wearing the skates
	begin;
		say "You don't want to stand barefoot in the cold!";
	otherwise;
		continue the action;
	end if.
Instead of taking off the boots:
	if the player is on the bench
	begin;
		continue the action;		
	otherwise;
		if the player is wearing the boots
		begin;
			say "You don't want to stand barefoot in the cold!";
		otherwise;
			continue the action;
		end if;
	end if.
Instead of taking off the skates:
	if the player is on the bench
	begin;
		continue the action;
	otherwise;
		if the player is wearing the skates
		begin;
			say "You don't want to stand barefoot in the cold!";
		otherwise;
			continue the action;
		end if;
	end if.

Skating is an action applying to nothing.
Understand "skate" as skating.
has_skated is a number variable. has_skated is 0.
Instead of skating when the player is in An Icy Expanse:
	if the player is wearing the skates
	begin;
		if has_skated is 0
		begin;
			say "You step gingerly onto the ice and skate a figure eight across the pond.";
			award 1 point;
		otherwise;
			say "You do another figure eight around the pond.";
		end if;
		change has_skated to 1;
	otherwise;
		say "You're not wearing skates!";
	end if.
Instead of skating when the player is on the bench:
	say "(first getting off the bench)[command clarification break]";
	silently try exiting;
	try skating;
Instead of skating when the player is in A Snowy Expanse:
	say "You don't see anything to skate on here."
	
	[[[[[ Snowman puzzle ]]]]]

The snowman is a supporter in the icy expanse. It is fixed in place. 

The description of the snowman is "Upon closer inspection, the snowman seems to be missing a head."

Rule for printing the name of the snowman when the snowball is on the snowman:
	say "happy snowman";
	omit contents in listing.

Check putting something on the snowman:
	if the noun is not the snowball, say "Why would you want to put that on the snowman?" instead.
	
Report putting the snowball on the snowman:
	say "Snowman completed!";
	if the score is less than 2, award 1 point;
	stop the action.
	
Instead of examining the snowman when the snowball is on the snowman:
	say "He looks rather happy to have a head."
	
Instead of taking the snowball when the snowball is on the snowman:
	say "You couldn't bear to decapitate Mr. Snowman."

